/********************************************************************//**
 * \file iap2_subparameters.h
 * \brief iAP2 Control session Sub-parameters
 *
 * \version $ $
 *
 * This header file declares structures associated with iAP2 SubParameters.
 *
 * \component global definition file
 *
 * \author Konrad Gerhards/ADITG/ kgerhards@de.adit-jv.com
 *
 * \copyright (c) 2010 - 2016 ADIT Corporation
 *
 * \warning CAUTION: CODES IN THIS FILE ARE AUTOMATCALLY GENERATED BY ENTERPRISE ARCHITECHT,
 *          DO NOT CHANGE THE CODE MANUALLY.
 ***********************************************************************/

#ifndef IAP2_SUBPARAMETERS_H
#define IAP2_SUBPARAMETERS_H

#ifdef __cplusplus
extern "C" {
#endif

#include "iap2_enums.h"
#include "iap2_defines.h"

/**
 * \brief BluetoothComponentProfiles group
 */
typedef struct
{
    /**
    * \brief Present if bluetooth advanced level audio distribution is supported in apple device
    */
    U8* iAP2BluetoothAdvancedAudioDistributionProfile;
    /**
     * \brief Number of occurrences of iAP2BluetoothAdvancedAudioDistributionProfile parameter
     */
    U16 iAP2BluetoothAdvancedAudioDistributionProfile_count;

    /**
    * \brief Present if Bluetooth Audio video Remote control is supported in apple device
    */
    U8* iAP2BluetoothAudioVideoRemotecontrolProfile;
    /**
     * \brief Number of occurrences of iAP2BluetoothAudioVideoRemotecontrolProfile parameter
     */
    U16 iAP2BluetoothAudioVideoRemotecontrolProfile_count;

    /**
    * \brief Present if Bluetooth Handsfree feature is supported in device
    */
    U8* iAP2BluetoothHandsFreeProfile;
    /**
     * \brief Number of occurrences of iAP2BluetoothHandsFreeProfile parameter
     */
    U16 iAP2BluetoothHandsFreeProfile_count;

    /**
    * \brief Present if HID device can be used to control apple device
    over bluetooth
    */
    U8* iAP2BluetoothHumanInterfaceDeviceProfile;
    /**
     * \brief Number of occurrences of iAP2BluetoothHumanInterfaceDeviceProfile parameter
     */
    U16 iAP2BluetoothHumanInterfaceDeviceProfile_count;

    /**
    * \brief Present if iAP2 Link can be accessed over bluetooth
    */
    U8* iAP2BluetoothiAP2LinkProfile;
    /**
     * \brief Number of occurrences of iAP2BluetoothiAP2LinkProfile parameter
     */
    U16 iAP2BluetoothiAP2LinkProfile_count;

    /**
    * \brief Present if messages can be accessed over Bluetooth
    */
    U8* iAP2BluetoothMessageAccessProfile;
    /**
     * \brief Number of occurrences of iAP2BluetoothMessageAccessProfile parameter
     */
    U16 iAP2BluetoothMessageAccessProfile_count;

    /**
    * \brief Present if apple device is in client role
    */
    U8* iAP2BluetoothPersonalAreaNetworkAccessPointProfile;
    /**
     * \brief Number of occurrences of iAP2BluetoothPersonalAreaNetworkAccessPointProfile parameter
     */
    U16 iAP2BluetoothPersonalAreaNetworkAccessPointProfile_count;

    /**
    * \brief Present if apple device is in access point role
    */
    U8* iAP2BluetoothPersonalAreaNetworkClientProfile;
    /**
     * \brief Number of occurrences of iAP2BluetoothPersonalAreaNetworkClientProfile parameter
     */
    U16 iAP2BluetoothPersonalAreaNetworkClientProfile_count;

    /**
    * \brief Present if Phone book can be accessed over bluetooth
    */
    U8* iAP2BluetoothPhoneBookAccessProfile;
    /**
     * \brief Number of occurrences of iAP2BluetoothPhoneBookAccessProfile parameter
     */
    U16 iAP2BluetoothPhoneBookAccessProfile_count;

} iAP2BluetoothComponentProfiles;

/**
 * \brief BluetoothComponentStatus group
 */
typedef struct
{
    /**
    * \brief TRUE or FALSE
    *
    * True if the bluetooth component is ready for
    connections with Apple device.
    */
    U8* iAP2BTComponentEnabled;
    /**
     * \brief Number of occurrences of iAP2BTComponentEnabled parameter
     */
    U16 iAP2BTComponentEnabled_count;

    /**
    * \brief Component Identifier of Bluetooth component
    *
    * Refers to iAP2TransportComponentIdentifier of iAP2BluetoothTransportComponent
    */
    U16* iAP2BTComponentIdentifier;
    /**
     * \brief Number of occurrences of iAP2BTComponentIdentifier parameter
     */
    U16 iAP2BTComponentIdentifier_count;

} iAP2BluetoothComponentStatus;

/**
 * \brief BluetoothHIDComponent group
 */
typedef struct
{
    /**
    * \brief BT Transport Component Identifier
    */
    U16* iAP2BluetoothTransportComponentIdentifier;
    /**
     * \brief Number of occurrences of iAP2BluetoothTransportComponentIdentifier parameter
     */
    U16 iAP2BluetoothTransportComponentIdentifier_count;

    /**
    * \brief HID Component function
    */
    iAP2HIDComponentFunction* iAP2HIDComponentFunction;
    /**
     * \brief Number of occurrences of iAP2HIDComponentFunction parameter
     */
    U16 iAP2HIDComponentFunction_count;

    /**
    * \brief HID component Identifier
    * All HID Component Identifiers must be unique
    */
    U16* iAP2HIDComponentIdentifier;
    /**
     * \brief Number of occurrences of iAP2HIDComponentIdentifier parameter
     */
    U16 iAP2HIDComponentIdentifier_count;

    /**
    * \brief Name of Bluetooth HID component
     */
    U8** iAP2HIDComponentName;
    /**
     * \brief Number of occurrences of iAP2HIDComponentName parameter
     */
    U16 iAP2HIDComponentName_count;

} iAP2BluetoothHIDComponent;

/**
 * \brief BluetoothTransportComponent group
 */
typedef struct
{
    /**
    * \brief A valid 6 byte IEEE EUI-48 identifier
    *
    * It contains MAC address of the bluetooth component.
    */
    iAP2Blob* iAP2BluetoothTransportMediaAccessControlAddress;
    /**
     * \brief Number of occurrences of iAP2BluetoothTransportMediaAccessControlAddress parameter
     */
    U16 iAP2BluetoothTransportMediaAccessControlAddress_count;

    /**
    * \brief Unique identifier for Bluetooth connection
    */
    U16* iAP2TransportComponentIdentifier;
    /**
     * \brief Number of occurrences of iAP2TransportComponentIdentifier parameter
     */
    U16 iAP2TransportComponentIdentifier_count;

    /** 
    * \brief Bluetooth Transport component name.
    *
    * It takes null-terminated UTF-8 string
    */
    U8** iAP2TransportComponentName;
    /**
     * \brief Number of occurrences of iAP2TransportComponentName parameter
     */
    U16 iAP2TransportComponentName_count;

    /**
    * \brief Present, If Bluetooth component supports iAP2 connection.
    */
    U8* iAP2TransportSupportsiAP2Connection;
    /**
     * \brief Number of occurrences of iAP2TransportSupportsiAP2Connection parameter
     */
    U16 iAP2TransportSupportsiAP2Connection_count;

} iAP2BluetoothTransportComponent;

/**
 * \brief Device_t group
 */
/**
 * \brief ExternalAccessoryProtocol group
 */
typedef struct
{
    
    U8* iAP2ExternalAccessoryProtocolCarPlay;
    /**
     * \brief Number of occurrences of iAP2ExternalAccessoryProtocolCarPlay parameter
     */
    U16 iAP2ExternalAccessoryProtocolCarPlay_count;

    /**
    * \brief Unique External Accessory Protocol identifier
    *
    * It refers iAP2ExternalAccessoryProtocolIdentifier of iAP2ExternalAccessoryProtocol
    */
    U8* iAP2ExternalAccessoryProtocolIdentifier;
    /**
     * \brief Number of occurrences of iAP2ExternalAccessoryProtocolIdentifier parameter
     */
    U16 iAP2ExternalAccessoryProtocolIdentifier_count;

    /**
    * \brief It specifies whether device will attempt to find match app.
    *
    * It refers to enum iAP2ExternalAccessoryProtocolMatchAction
    */
    iAP2ExternalAccessoryProtocolMatchAction* iAP2ExternalAccessoryProtocolMatchAction;
    /**
     * \brief Number of occurrences of iAP2ExternalAccessoryProtocolMatchAction parameter
     */
    U16 iAP2ExternalAccessoryProtocolMatchAction_count;

    /**
    * \brief Name of External Accessory Protocol
    *
    * It is of type string
    */
    U8** iAP2ExternalAccessoryProtocolName;
    /**
     * \brief Number of occurrences of iAP2ExternalAccessoryProtocolName parameter
     */
    U16 iAP2ExternalAccessoryProtocolName_count;

    /**
    * \brief It refers to a iAP2TransportComponentIdentifier of a declared iAP2USBHostTransportComponent
    */
    U16* iAP2NativeTransportComponentIdentifier;
    /**
     * \brief Number of occurrences of iAP2NativeTransportComponentIdentifier parameter
     */
    U16 iAP2NativeTransportComponentIdentifier_count;

} iAP2ExternalAccessoryProtocol;

/**
 * \brief FavoritesList group
 */
typedef struct
{
    /**
    * \brief ID of Address Book
    */
    U8** iAP2AddressBookID;
    /**
     * \brief Number of occurrences of iAP2AddressBookID parameter
     */
    U16 iAP2AddressBookID_count;

    /**
    * \brief Display Name
    */
    U8** iAP2DisplayName;
    /**
     * \brief Number of occurrences of iAP2DisplayName parameter
     */
    U16 iAP2DisplayName_count;

    /**
    * \brief Request index of list entry
    */
    U16* iAP2Index;
    /**
     * \brief Number of occurrences of iAP2Index parameter
     */
    U16 iAP2Index_count;

    /**
    * \brief Label if in contacts, location if not
    */
    U8** iAP2Label;
    /**
     * \brief Number of occurrences of iAP2Label parameter
     */
    U16 iAP2Label_count;

    /**
    * \brief Remote phone number or email
    */
    U8** iAP2RemoteID;
    /**
     * \brief Number of occurrences of iAP2RemoteID parameter
     */
    U16 iAP2RemoteID_count;

    /**
    * \brief List Update Service
    */
    iAP2ListUpdateService* iAP2Service;
    /**
     * \brief Number of occurrences of iAP2Service parameter
     */
    U16 iAP2Service_count;

} iAP2FavoritesList;

/**
 * \brief FavoritesListProperties group
 */
typedef struct
{
    /**
    * \brief ID of Address Book
    */
    U8* iAP2AddressBookID;
    /**
     * \brief Number of occurrences of iAP2AddressBookID parameter
     */
    U16 iAP2AddressBookID_count;

    /**
    * \brief Display Name
    */
    U8* iAP2DisplayName;
    /**
     * \brief Number of occurrences of iAP2DisplayName parameter
     */
    U16 iAP2DisplayName_count;

    /**
    * \brief Request index of list entry
    */
    U8* iAP2Index;
    /**
     * \brief Number of occurrences of iAP2Index parameter
     */
    U16 iAP2Index_count;

    /**
    * \brief Label if in contacts, location if not
    */
    U8* iAP2Label;
    /**
     * \brief Number of occurrences of iAP2Label parameter
     */
    U16 iAP2Label_count;

    /**
    * \brief Remote phone number or email
    */
    U8* iAP2RemoteID;
    /**
     * \brief Number of occurrences of iAP2RemoteID parameter
     */
    U16 iAP2RemoteID_count;

    /**
    * \brief List Update Service
    */
    U8* iAP2Service;
    /**
     * \brief Number of occurrences of iAP2Service parameter
     */
    U16 iAP2Service_count;

} iAP2FavoritesListProperties;

/**
 * \brief iAP2HIDComponent group
 */
typedef struct
{
    /**
    * \brief It specifies HID component function type.
    *
    * It refers to enum iAP2HIDComponentFunction
    */
    iAP2HIDComponentFunction* iAP2HIDComponentFunction;
    /**
     * \brief Number of occurrences of iAP2HIDComponentFunction parameter
     */
    U16 iAP2HIDComponentFunction_count;

    /**
    * \brief Identifier of HID component.
    *
    * Must be unique HIDComponentIdentifier specified by the Accessory
    */
    U16* iAP2HIDComponentIdentifier;
    /**
     * \brief Number of occurrences of iAP2HIDComponentIdentifier parameter
     */
    U16 iAP2HIDComponentIdentifier_count;

    /**
    * \brief Name of HID component.
    *
    * It takes null-terminated UTF-8 string
    */
    U8** iAP2HIDComponentName;
    /**
     * \brief Number of occurrences of iAP2HIDComponentName parameter
     */
    U16 iAP2HIDComponentName_count;

} iAP2iAP2HIDComponent;

/**
 * \brief LocationInformationComponent group
 */
typedef struct
{
    /**
    * \brief Present, if application is ready to send NMEA GPGGA sentences
    */
    U8* iAP2LocationInformationComponentGlobalPositioningSystemFixData;
    /**
     * \brief Number of occurrences of iAP2LocationInformationComponentGlobalPositioningSystemFixData parameter
     */
    U16 iAP2LocationInformationComponentGlobalPositioningSystemFixData_count;

    /**
    * \brief Present, if application is ready to send NMEA GPGSV sentences
    */
    U8* iAP2LocationInformationComponentGPSSatelliteInView;
    /**
     * \brief Number of occurrences of iAP2LocationInformationComponentGPSSatelliteInView parameter
     */
    U16 iAP2LocationInformationComponentGPSSatelliteInView_count;

    /**
    * \brief Identifier of LocationInformation component
    *
    * All LocationInformationComponentIdentifiers must be unique
    */
    U16* iAP2LocationInformationComponentIdentifier;
    /**
     * \brief Number of occurrences of iAP2LocationInformationComponentIdentifier parameter
     */
    U16 iAP2LocationInformationComponentIdentifier_count;

    /**
    * \brief Name of Location Information component
    */
    U8** iAP2LocationInformationComponentName;
    /**
     * \brief Number of occurrences of iAP2LocationInformationComponentName parameter
     */
    U16 iAP2LocationInformationComponentName_count;

    /**
    * \brief Present, if application is ready to send NMEA GPRMC sentences
    */
    U8* iAP2LocationInformationComponentRecommendedMinimumSpecificGPSTransitData;
    /**
     * \brief Number of occurrences of iAP2LocationInformationComponentRecommendedMinimumSpecificGPSTransitData parameter
     */
    U16 iAP2LocationInformationComponentRecommendedMinimumSpecificGPSTransitData_count;

    /**
    * \brief Present, if application is ready to send NMEA PAAACD sentences
    */
    U8* iAP2LocationInformationComponentVehicleAccelerometerData;
    /**
     * \brief Number of occurrences of iAP2LocationInformationComponentVehicleAccelerometerData parameter
     */
    U16 iAP2LocationInformationComponentVehicleAccelerometerData_count;

    /**
    * \brief Present, if application is ready to send NMEA PAGCD sentences
    */
    U8* iAP2LocationInformationComponentVehicleGyroData;
    /**
     * \brief Number of occurrences of iAP2LocationInformationComponentVehicleGyroData parameter
     */
    U16 iAP2LocationInformationComponentVehicleGyroData_count;

    /**
    * \brief Present, if application is ready to send NMEA GPHDT sentences
    */
    U8* iAP2LocationInformationComponentVehicleHeadingData;
    /**
     * \brief Number of occurrences of iAP2LocationInformationComponentVehicleHeadingData parameter
     */
    U16 iAP2LocationInformationComponentVehicleHeadingData_count;

    /**
    * \brief Present, if application is ready to send NMEA PASCD sentences
    */
    U8* iAP2LocationInformationComponentVehicleSpeedData;
    /**
     * \brief Number of occurrences of iAP2LocationInformationComponentVehicleSpeedData parameter
     */
    U16 iAP2LocationInformationComponentVehicleSpeedData_count;

} iAP2LocationInformationComponent;

/**
 * \brief MediaItem group
 */
typedef struct
{
    /**
    * \brief Media item album artist
    */
    U8** iAP2MediaItemAlbumArtist;
    /**
     * \brief Number of occurrences of iAP2MediaItemAlbumArtist parameter
     */
    U16 iAP2MediaItemAlbumArtist_count;

    /**
    * \brief Persistent identifier of media item album
    */
    U64* iAP2MediaItemAlbumArtistPersistentIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaItemAlbumArtistPersistentIdentifier parameter
     */
    U16 iAP2MediaItemAlbumArtistPersistentIdentifier_count;

    /**
    * \brief Number of discs in media item album
    */
    U16* iAP2MediaItemAlbumDiscCount;
    /**
     * \brief Number of occurrences of iAP2MediaItemAlbumDiscCount parameter
     */
    U16 iAP2MediaItemAlbumDiscCount_count;

    /**
    * \brief Disc number of Media item album
    */
    U16* iAP2MediaItemAlbumDiscNumber;
    /**
     * \brief Number of occurrences of iAP2MediaItemAlbumDiscNumber parameter
     */
    U16 iAP2MediaItemAlbumDiscNumber_count;

    /**
    * \brief Persistent identifier of media item album
    */
    U64* iAP2MediaItemAlbumPersistentIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaItemAlbumPersistentIdentifier parameter
     */
    U16 iAP2MediaItemAlbumPersistentIdentifier_count;

    /**
    * \brief Title of media item album
    */
    U8** iAP2MediaItemAlbumTitle;
    /**
     * \brief Number of occurrences of iAP2MediaItemAlbumTitle parameter
     */
    U16 iAP2MediaItemAlbumTitle_count;

    /**
    * \brief Number of tracks in media item album
    */
    U16* iAP2MediaItemAlbumTrackCount;
    /**
     * \brief Number of occurrences of iAP2MediaItemAlbumTrackCount parameter
     */
    U16 iAP2MediaItemAlbumTrackCount_count;

    /**
    * \brief Track number of media item album
    */
    U16* iAP2MediaItemAlbumTrackNumber;
    /**
     * \brief Number of occurrences of iAP2MediaItemAlbumTrackNumber parameter
     */
    U16 iAP2MediaItemAlbumTrackNumber_count;

    /**
    * \brief Media item artist
    */
    U8** iAP2MediaItemArtist;
    /**
     * \brief Number of occurrences of iAP2MediaItemArtist parameter
     */
    U16 iAP2MediaItemArtist_count;

    /**
    * \brief Persistent identifier of media item artist
    */
    U64* iAP2MediaItemArtistPersistentIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaItemArtistPersistentIdentifier parameter
     */
    U16 iAP2MediaItemArtistPersistentIdentifier_count;

    /**
    * \brief File transfer identifier of media item artwork.
    *
    * It is used to receive artwork from apple device.
    */
    U8* iAP2MediaItemArtworkFileTransferIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaItemArtworkFileTransferIdentifier parameter
     */
    U16 iAP2MediaItemArtworkFileTransferIdentifier_count;

    
    U16* iAP2MediaItemChapterCount;
    /**
     * \brief Number of occurrences of iAP2MediaItemChapterCount parameter
     */
    U16 iAP2MediaItemChapterCount_count;

    /**
    * \brief Media item composer
    */
    U8** iAP2MediaItemComposer;
    /**
     * \brief Number of occurrences of iAP2MediaItemComposer parameter
     */
    U16 iAP2MediaItemComposer_count;

    /**
    * \brief Persistent identifier of Media item composer
    */
    U64* iAP2MediaItemComposerPersistentIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaItemComposerPersistentIdentifier parameter
     */
    U16 iAP2MediaItemComposerPersistentIdentifier_count;

    /**
    * \brief Media Item genre
    *
    * It is of type null-terminated UTF-8 string
    */
    U8** iAP2MediaItemGenre;
    /**
     * \brief Number of occurrences of iAP2MediaItemGenre parameter
     */
    U16 iAP2MediaItemGenre_count;

    /**
    * \brief Persistent identifier of media item genre
    */
    U64* iAP2MediaItemGenrePersistentIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaItemGenrePersistentIdentifier parameter
     */
    U16 iAP2MediaItemGenrePersistentIdentifier_count;

    /**
    * \brief TRUE or FALSE
    *
    * TRUE if media item is already banned
    */
    U8* iAP2MediaItemIsBanned;
    /**
     * \brief Number of occurrences of iAP2MediaItemIsBanned parameter
     */
    U16 iAP2MediaItemIsBanned_count;

    /**
    * \brief TRUE or FALSE
    *
    * TRUE if media item is ban supported
    */
    U8* iAP2MediaItemIsBanSupported;
    /**
     * \brief Number of occurrences of iAP2MediaItemIsBanSupported parameter
     */
    U16 iAP2MediaItemIsBanSupported_count;

    /**
    * \brief TRUE or FALSE
    *
    * TRUE if media item is already liked
    */
    U8* iAP2MediaItemIsLiked;
    /**
     * \brief Number of occurrences of iAP2MediaItemIsLiked parameter
     */
    U16 iAP2MediaItemIsLiked_count;

    /**
    * \brief TRUE or FALSE
    *
    * TRUE if media item is like supported
    */
    U8* iAP2MediaItemIsLikeSupported;
    /**
     * \brief Number of occurrences of iAP2MediaItemIsLikeSupported parameter
     */
    U16 iAP2MediaItemIsLikeSupported_count;

    /**
    * \brief TRUE or FALSE
    *
    * TRUE if media item is part of compilation
    */
    U8* iAP2MediaItemIsPartOfCompilation;
    /**
     * \brief Number of occurrences of iAP2MediaItemIsPartOfCompilation parameter
     */
    U16 iAP2MediaItemIsPartOfCompilation_count;

    /**
    * \brief TRUE or FALSE
    *
    * TRUE if accessory is resident on apple device
    */
    U8* iAP2MediaItemIsResidentOnDevice;
    /**
     * \brief Number of occurrences of iAP2MediaItemIsResidentOnDevice parameter
     */
    U16 iAP2MediaItemIsResidentOnDevice_count;

    /**
    * \brief Media type of Media Item
    *
    * It refers to enum iAP2MediaType
    */
    iAP2MediaType* iAP2MediaItemMediaType;
    /**
     * \brief Number of occurrences of iAP2MediaItemMediaType parameter
     */
    U16 iAP2MediaItemMediaType_count;

    /**
    * \brief Persistent identifier of media item
    */
    U64* iAP2MediaItemPersistentIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaItemPersistentIdentifier parameter
     */
    U16 iAP2MediaItemPersistentIdentifier_count;

    /**
    * \brief Playback duration of media item in milliseconds
    */
    U32* iAP2MediaItemPlaybackDurationInMilliseconds;
    /**
     * \brief Number of occurrences of iAP2MediaItemPlaybackDurationInMilliseconds parameter
     */
    U16 iAP2MediaItemPlaybackDurationInMilliseconds_count;

    /**
    * \brief Media item rating
    */
    U8* iAP2MediaItemRating;
    /**
     * \brief Number of occurrences of iAP2MediaItemRating parameter
     */
    U16 iAP2MediaItemRating_count;

    /**
    * \brief Title of media item
    */
    U8** iAP2MediaItemTitle;
    /**
     * \brief Number of occurrences of iAP2MediaItemTitle parameter
     */
    U16 iAP2MediaItemTitle_count;

} iAP2MediaItem;

/**
 * \brief MediaItemAttributes group
 */
typedef struct
{
    /**
    * \brief Present if application wish to receive album disc count of media item
    */
    U8* iAP2MediaItemAlbumDiscCount;
    /**
     * \brief Number of occurrences of iAP2MediaItemAlbumDiscCount parameter
     */
    U16 iAP2MediaItemAlbumDiscCount_count;

    /**
    * \brief Present if application wish to receive album disc number of media item
    */
    U8* iAP2MediaItemAlbumDiscNumber;
    /**
     * \brief Number of occurrences of iAP2MediaItemAlbumDiscNumber parameter
     */
    U16 iAP2MediaItemAlbumDiscNumber_count;

    /**
    * \brief Present if application wish to receive album title of media item
    */
    U8* iAP2MediaItemAlbumTitle;
    /**
     * \brief Number of occurrences of iAP2MediaItemAlbumTitle parameter
     */
    U16 iAP2MediaItemAlbumTitle_count;

    /**
    * \brief Present if application wish to receive album track count of media item
    */
    U8* iAP2MediaItemAlbumTrackCount;
    /**
     * \brief Number of occurrences of iAP2MediaItemAlbumTrackCount parameter
     */
    U16 iAP2MediaItemAlbumTrackCount_count;

    /**
    * \brief Present if application wish to receive album track number of media item
    */
    U8* iAP2MediaItemAlbumTrackNumber;
    /**
     * \brief Number of occurrences of iAP2MediaItemAlbumTrackNumber parameter
     */
    U16 iAP2MediaItemAlbumTrackNumber_count;

    /**
    * \brief Present if application wish to receive media item artist
    */
    U8* iAP2MediaItemArtist;
    /**
     * \brief Number of occurrences of iAP2MediaItemArtist parameter
     */
    U16 iAP2MediaItemArtist_count;

    /**
    * \brief Present if application wish to receive artwork data of media item
    */
    U8* iAP2MediaItemArtworkFileTransferIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaItemArtworkFileTransferIdentifier parameter
     */
    U16 iAP2MediaItemArtworkFileTransferIdentifier_count;

    
    U8* iAP2MediaItemChapterCount;
    /**
     * \brief Number of occurrences of iAP2MediaItemChapterCount parameter
     */
    U16 iAP2MediaItemChapterCount_count;

    /**
    * \brief Present if application wish to receive media item composer
    */
    U8* iAP2MediaItemComposer;
    /**
     * \brief Number of occurrences of iAP2MediaItemComposer parameter
     */
    U16 iAP2MediaItemComposer_count;

    /**
    * \brief Present if application wish to receive media item genre
    */
    U8* iAP2MediaItemGenre;
    /**
     * \brief Number of occurrences of iAP2MediaItemGenre parameter
     */
    U16 iAP2MediaItemGenre_count;

    /**
    * \brief Present if application wish to know whether media item is banned or not
    */
    U8* iAP2MediaItemIsBanned;
    /**
     * \brief Number of occurrences of iAP2MediaItemIsBanned parameter
     */
    U16 iAP2MediaItemIsBanned_count;

    /**
    * \brief Present if application wish to know whether ban is supported for media item or not
    */
    U8* iAP2MediaItemIsBanSupported;
    /**
     * \brief Number of occurrences of iAP2MediaItemIsBanSupported parameter
     */
    U16 iAP2MediaItemIsBanSupported_count;

    /**
    * \brief Present if application wish to know whether media item is liked or not
    */
    U8* iAP2MediaItemIsLiked;
    /**
     * \brief Number of occurrences of iAP2MediaItemIsLiked parameter
     */
    U16 iAP2MediaItemIsLiked_count;

    /**
    * \brief Present if application wish to know whether like is supported for media item or not
    */
    U8* iAP2MediaItemIsLikeSupported;
    /**
     * \brief Number of occurrences of iAP2MediaItemIsLikeSupported parameter
     */
    U16 iAP2MediaItemIsLikeSupported_count;

    /**
    * \brief Present if application wish to receive 
    * MediaItemPersistentIdentifier as part of NowPlayingUpdates message
    */
    U8* iAP2MediaItemPersistentIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaItemPersistentIdentifier parameter
     */
    U16 iAP2MediaItemPersistentIdentifier_count;

    /**
    * \brief Present if application wish to receive playback duration of media item
    */
    U8* iAP2MediaItemPlaybackDurationInMilliseconds;
    /**
     * \brief Number of occurrences of iAP2MediaItemPlaybackDurationInMilliseconds parameter
     */
    U16 iAP2MediaItemPlaybackDurationInMilliseconds_count;

    /**
    * \brief Present if application wish to receive title of media item
    */
    U8* iAP2MediaItemTitle;
    /**
     * \brief Number of occurrences of iAP2MediaItemTitle parameter
     */
    U16 iAP2MediaItemTitle_count;

} iAP2MediaItemAttributes;

/**
 * \brief MediaItemProperties group
 */
typedef struct
{
    /**
    * \brief Present if the application wish to receive album artist of media item
    */
    U8* iAP2MediaItemPropertyAlbumArtist;
    /**
     * \brief Number of occurrences of iAP2MediaItemPropertyAlbumArtist parameter
     */
    U16 iAP2MediaItemPropertyAlbumArtist_count;

    /**
    * \brief Present if the application wish to receive persistent identifier of media item album artist
    */
    U8* iAP2MediaItemPropertyAlbumArtistPersistentIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaItemPropertyAlbumArtistPersistentIdentifier parameter
     */
    U16 iAP2MediaItemPropertyAlbumArtistPersistentIdentifier_count;

    /**
    * \brief Present if the application wish to receive number of discs in media item album
    */
    U8* iAP2MediaItemPropertyAlbumDiscCount;
    /**
     * \brief Number of occurrences of iAP2MediaItemPropertyAlbumDiscCount parameter
     */
    U16 iAP2MediaItemPropertyAlbumDiscCount_count;

    /**
    * \brief present if the application wish to receive disc number of media item album
    */
    U8* iAP2MediaItemPropertyAlbumDiscNumber;
    /**
     * \brief Number of occurrences of iAP2MediaItemPropertyAlbumDiscNumber parameter
     */
    U16 iAP2MediaItemPropertyAlbumDiscNumber_count;

    /**
    * \brief Present if the application wish to receive persistent identifier of media item album
    */
    U8* iAP2MediaItemPropertyAlbumPersistentIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaItemPropertyAlbumPersistentIdentifier parameter
     */
    U16 iAP2MediaItemPropertyAlbumPersistentIdentifier_count;

    /**
    * \brief Present if the application wish to receive title of media item album
    */
    U8* iAP2MediaItemPropertyAlbumTitle;
    /**
     * \brief Number of occurrences of iAP2MediaItemPropertyAlbumTitle parameter
     */
    U16 iAP2MediaItemPropertyAlbumTitle_count;

    /**
    * \brief Present if the application wish to receive number of tracks 
    in media item album.
    */
    U8* iAP2MediaItemPropertyAlbumTrackCount;
    /**
     * \brief Number of occurrences of iAP2MediaItemPropertyAlbumTrackCount parameter
     */
    U16 iAP2MediaItemPropertyAlbumTrackCount_count;

    /**
    * \brief Present if the application wish to receive media item album track number
    */
    U8* iAP2MediaItemPropertyAlbumTrackNumber;
    /**
     * \brief Number of occurrences of iAP2MediaItemPropertyAlbumTrackNumber parameter
     */
    U16 iAP2MediaItemPropertyAlbumTrackNumber_count;

    /**
    * \brief Present if the application wish to receive media item artist
    */
    U8* iAP2MediaItemPropertyArtist;
    /**
     * \brief Number of occurrences of iAP2MediaItemPropertyArtist parameter
     */
    U16 iAP2MediaItemPropertyArtist_count;

    /**
    * \brief Present if the application wish to receive persistent identifier of media item artist
    */
    U8* iAP2MediaItemPropertyArtistPersistentIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaItemPropertyArtistPersistentIdentifier parameter
     */
    U16 iAP2MediaItemPropertyArtistPersistentIdentifier_count;

    
    U8* iAP2MediaItemPropertyChapterCount;
    /**
     * \brief Number of occurrences of iAP2MediaItemPropertyChapterCount parameter
     */
    U16 iAP2MediaItemPropertyChapterCount_count;

    /**
    * \brief Present if the application wish to receive media item genre
    */
    U8* iAP2MediaItemPropertyComposer;
    /**
     * \brief Number of occurrences of iAP2MediaItemPropertyComposer parameter
     */
    U16 iAP2MediaItemPropertyComposer_count;

    /**
    * \brief Present if the application wish to receive persistent identifier of media item composer
    */
    U8* iAP2MediaItemPropertyComposerPersistentIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaItemPropertyComposerPersistentIdentifier parameter
     */
    U16 iAP2MediaItemPropertyComposerPersistentIdentifier_count;

    /**
    * \brief Present if the application wish to receive media item genre
    */
    U8* iAP2MediaItemPropertyGenre;
    /**
     * \brief Number of occurrences of iAP2MediaItemPropertyGenre parameter
     */
    U16 iAP2MediaItemPropertyGenre_count;

    /**
    * \brief Present if the application wish to receive persistent identifier of media item genre
    */
    U8* iAP2MediaItemPropertyGenrePersistenIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaItemPropertyGenrePersistenIdentifier parameter
     */
    U16 iAP2MediaItemPropertyGenrePersistenIdentifier_count;

    /* The Parameter MediaItemPropertyIsBanned is Deprecated, Don't use it. Kindly refer the Apple specification. */
    /**
    * \brief Present if the application wish to know whether
    media item is banned or not
    */
    U8* iAP2MediaItemPropertyIsBanned;
    /**
     * \brief Number of occurrences of iAP2MediaItemPropertyIsBanned parameter
     */
    U16 iAP2MediaItemPropertyIsBanned_count;

    /* The Parameter MediaItemPropertyIsBanSupported is Deprecated, Don't use it. Kindly refer the Apple specification. */
    /**
    * \brief Present if the application wish to know whether
    Ban is supported for the media item or not
    */
    U8* iAP2MediaItemPropertyIsBanSupported;
    /**
     * \brief Number of occurrences of iAP2MediaItemPropertyIsBanSupported parameter
     */
    U16 iAP2MediaItemPropertyIsBanSupported_count;

    /* The Parameter MediaItemPropertyIsLiked is Deprecated, Don't use it. Kindly refer the Apple specification. */
    /**
    * \brief Present if the application wish to know whether
    media item is liked or not
    */
    U8* iAP2MediaItemPropertyIsLiked;
    /**
     * \brief Number of occurrences of iAP2MediaItemPropertyIsLiked parameter
     */
    U16 iAP2MediaItemPropertyIsLiked_count;

    /* The Parameter MediaItemPropertyIsLikeSupported is Deprecated, Don't use it. Kindly refer the Apple specification. */
    /**
    * \brief Present if the application wish to know whether
    Like is supported for the media item or not
    */
    U8* iAP2MediaItemPropertyIsLikeSupported;
    /**
     * \brief Number of occurrences of iAP2MediaItemPropertyIsLikeSupported parameter
     */
    U16 iAP2MediaItemPropertyIsLikeSupported_count;

    /**
    * \brief Present if the application wish to know whether media item is part of compilation
    */
    U8* iAP2MediaItemPropertyIsPartOfCompilation;
    /**
     * \brief Number of occurrences of iAP2MediaItemPropertyIsPartOfCompilation parameter
     */
    U16 iAP2MediaItemPropertyIsPartOfCompilation_count;

    /**
    * \brief Present if the application wish to know whether 
    the accessory is resident on apple device or not.
    */
    U8* iAP2MediaItemPropertyIsResidentOndevice;
    /**
     * \brief Number of occurrences of iAP2MediaItemPropertyIsResidentOndevice parameter
     */
    U16 iAP2MediaItemPropertyIsResidentOndevice_count;

    /**
    * \brief Present if the application wish to receive Media Item type
    */
    U8* iAP2MediaItemPropertyMediaType;
    /**
     * \brief Number of occurrences of iAP2MediaItemPropertyMediaType parameter
     */
    U16 iAP2MediaItemPropertyMediaType_count;

    /**
    * \brief This parameter must be set to receive Media Item persistent identifier
    */
    U8* iAP2MediaItemPropertyPersistentIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaItemPropertyPersistentIdentifier parameter
     */
    U16 iAP2MediaItemPropertyPersistentIdentifier_count;

    /**
    * \brief Present if the application wish to receive Media Item playback duration(in mS)
    */
    U8* iAP2MediaItemPropertyPlaybackDurationInMilliseconds;
    /**
     * \brief Number of occurrences of iAP2MediaItemPropertyPlaybackDurationInMilliseconds parameter
     */
    U16 iAP2MediaItemPropertyPlaybackDurationInMilliseconds_count;

    /**
    * \brief Present if the application wish to receive Media Item Rating
    */
    U8* iAP2MediaItemPropertyRating;
    /**
     * \brief Number of occurrences of iAP2MediaItemPropertyRating parameter
     */
    U16 iAP2MediaItemPropertyRating_count;

    /**
    * \brief Present if the application wish to receive Media Item title
    */
    U8* iAP2MediaItemPropertyTitle;
    /**
     * \brief Number of occurrences of iAP2MediaItemPropertyTitle parameter
     */
    U16 iAP2MediaItemPropertyTitle_count;

} iAP2MediaItemProperties;

/**
 * \brief MediaLibraryInformationSub group
 */
typedef struct
{
    /**
    * \brief Name of the Media Library
    *
    * It is a null-terminated UTF-8 string
    */
    U8** iAP2MediaLibraryName;
    /**
     * \brief Number of occurrences of iAP2MediaLibraryName parameter
     */
    U16 iAP2MediaLibraryName_count;

    /**
    * \brief Unique Media Library Identifier
    *
    * It is of type string
    */
    U8** iAP2MediaUniqueIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaUniqueIdentifier parameter
     */
    U16 iAP2MediaUniqueIdentifier_count;

    /**
    * \brief It describes media library type
    *
    * It refers to enum iAP2MediaLibraryType
    */
    iAP2MediaLibraryType* iAP2MediaLibraryType;
    /**
     * \brief Number of occurrences of iAP2MediaLibraryType parameter
     */
    U16 iAP2MediaLibraryType_count;

} iAP2MediaLibraryInformationSubParameter;

/**
 * \brief MediaPlayList group
 */
typedef struct
{
    /**
    * \brief File Transfer Identifier of contained media items
    */
    U8* iAP2MediaPlaylistContainedMediaItemsFileTransferIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaPlaylistContainedMediaItemsFileTransferIdentifier parameter
     */
    U16 iAP2MediaPlaylistContainedMediaItemsFileTransferIdentifier_count;

    /**
    * \brief TRUE or FALSE
    *
    * TRUE if Playlist contains Apple Music Radio station
    */
    U8* iAP2MediaPlaylistIsAppleMusicRadioStation;
    /**
     * \brief Number of occurrences of iAP2MediaPlaylistIsAppleMusicRadioStation parameter
     */
    U16 iAP2MediaPlaylistIsAppleMusicRadioStation_count;

    /**
    * \brief TRUE or FALSE
    *
    * TRUE if the playlist contains folders
    */
    U8* iAP2MediaPlaylistIsFolder;
    /**
     * \brief Number of occurrences of iAP2MediaPlaylistIsFolder parameter
     */
    U16 iAP2MediaPlaylistIsFolder_count;

    /**
    * \brief TRUE or FALSE
    *
    * TRUE if Genius mix of the playlist is enabled
    */
    U8* iAP2MediaPlaylistIsGeniusMix;
    /**
     * \brief Number of occurrences of iAP2MediaPlaylistIsGeniusMix parameter
     */
    U16 iAP2MediaPlaylistIsGeniusMix_count;

    /* The Parameter MediaPlaylistIsiTunesRadioStation is Deprecated, Don't use it. Kindly refer the Apple specification. */
    /**
    * \brief TRUE or FALSE
    *
    * TRUE if Playlist contains iTunes Radion station
    */
    U8* iAP2MediaPlaylistIsiTunesRadioStation;
    /**
     * \brief Number of occurrences of iAP2MediaPlaylistIsiTunesRadioStation parameter
     */
    U16 iAP2MediaPlaylistIsiTunesRadioStation_count;

    /**
    * \brief Name of the media playlist.
    *
    * It is of type null-terminated UTF-8 string
    */
    U8** iAP2MediaPlaylistName;
    /**
     * \brief Number of occurrences of iAP2MediaPlaylistName parameter
     */
    U16 iAP2MediaPlaylistName_count;

    /**
    * \brief Parent persistent Identifier of Media playlist
    */
    U64* iAP2MediaPlaylistParentPersistentIdentifer;
    /**
     * \brief Number of occurrences of iAP2MediaPlaylistParentPersistentIdentifer parameter
     */
    U16 iAP2MediaPlaylistParentPersistentIdentifer_count;

    /**
    * \brief Persistent Identifier of Media playlist
    *
    * Every Playlist will contain unique persistent identifier
    */
    U64* iAP2MediaPlaylistPersistentIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaPlaylistPersistentIdentifier parameter
     */
    U16 iAP2MediaPlaylistPersistentIdentifier_count;

    
    U8* iAP2MediaPlaylistContentTransfer;
    /**
     * \brief Number of occurrences of iAP2MediaPlaylistContentTransfer parameter
     */
    U16 iAP2MediaPlaylistContentTransfer_count;

} iAP2MediaPlayList;

/**
 * \brief MediaPlaylistContentTransferInfoRequest group
 */
typedef struct
{
    
    U8* iAP2MedialtemPlD;
    /**
     * \brief Number of occurrences of iAP2MedialtemPlD parameter
     */
    U16 iAP2MedialtemPlD_count;

    
    U8* iAP2MedialtemTitle;
    /**
     * \brief Number of occurrences of iAP2MedialtemTitle parameter
     */
    U16 iAP2MedialtemTitle_count;

    
    U8* iAP2MediaItemAlbumTitle;
    /**
     * \brief Number of occurrences of iAP2MediaItemAlbumTitle parameter
     */
    U16 iAP2MediaItemAlbumTitle_count;

    
    U8* iAP2MediaItemArtist;
    /**
     * \brief Number of occurrences of iAP2MediaItemArtist parameter
     */
    U16 iAP2MediaItemArtist_count;

    
    U8* iAP2MedialtemAlbumArtist;
    /**
     * \brief Number of occurrences of iAP2MedialtemAlbumArtist parameter
     */
    U16 iAP2MedialtemAlbumArtist_count;

    
    U8* iAP2MediaItemGenre;
    /**
     * \brief Number of occurrences of iAP2MediaItemGenre parameter
     */
    U16 iAP2MediaItemGenre_count;

    
    U8* iAP2MediaItemComposer;
    /**
     * \brief Number of occurrences of iAP2MediaItemComposer parameter
     */
    U16 iAP2MediaItemComposer_count;

} iAP2MediaPlaylistContentTransferInfoRequest;

/**
 * \brief MediaPlaylistProperties group
 */
typedef struct
{
    /* The Parameter MediaPlayListContainedMediaItems is Deprecated, Don't use it. Kindly refer the Apple specification. */
    /**
    * \brief Present if application wish to know whether
    *
    * Media Playlist contains media items
    */
    U8* iAP2MediaPlayListContainedMediaItems;
    /**
     * \brief Number of occurrences of iAP2MediaPlayListContainedMediaItems parameter
     */
    U16 iAP2MediaPlayListContainedMediaItems_count;

    /**
    * \brief Present if application wish to know whether
    *
    * Media Playlist contains media items
    */
    U8* iAP2MediaPlayListContainedMediaItemsFileTransferIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaPlayListContainedMediaItemsFileTransferIdentifier parameter
     */
    U16 iAP2MediaPlayListContainedMediaItemsFileTransferIdentifier_count;

    /**
    * \brief Present if application wish to know whether 
    Media Playlist is Apple Music Radio Station
    */
    U8* iAP2MediaPlayListPropertyIsAppleMusicRadioStation;
    /**
     * \brief Number of occurrences of iAP2MediaPlayListPropertyIsAppleMusicRadioStation parameter
     */
    U16 iAP2MediaPlayListPropertyIsAppleMusicRadioStation_count;

    /**
    * \brief  Present if application wish to know whether 
    Media Playlist contains folders
    */
    U8* iAP2MediaPlayListPropertyIsFolder;
    /**
     * \brief Number of occurrences of iAP2MediaPlayListPropertyIsFolder parameter
     */
    U16 iAP2MediaPlayListPropertyIsFolder_count;

    /* The Parameter MediaPlayListPropertyIsiTunesRadioStation is Deprecated, Don't use it. Kindly refer the Apple specification. */
    /**
    * \brief Present if application wish to know whether 
    Media Playlist is iTunes Radio Station
    */
    U8* iAP2MediaPlayListPropertyIsiTunesRadioStation;
    /**
     * \brief Number of occurrences of iAP2MediaPlayListPropertyIsiTunesRadioStation parameter
     */
    U16 iAP2MediaPlayListPropertyIsiTunesRadioStation_count;

    /**
    * \brief Present if application wish to receive 
    Media Playlist property name
    */
    U8* iAP2MediaPlayListPropertyName;
    /**
     * \brief Number of occurrences of iAP2MediaPlayListPropertyName parameter
     */
    U16 iAP2MediaPlayListPropertyName_count;

    /**
    * \brief  Present if application wish to receive Media Playlist property parent persistent identifier
    */
    U8* iAP2MediaPlayListPropertyParentPersistentIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaPlayListPropertyParentPersistentIdentifier parameter
     */
    U16 iAP2MediaPlayListPropertyParentPersistentIdentifier_count;

    /**
    * \brief Present if application wish to receive Media Playlist property persistent identifier from apple device
    */
    U8* iAP2MediaPlayListPropertyPersistentIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaPlayListPropertyPersistentIdentifier parameter
     */
    U16 iAP2MediaPlayListPropertyPersistentIdentifier_count;

    /**
    * \brief Present if application wish to know whether 
    Genius mix is enabled for the playlist
    */
    U8* iAP2MediaPlayListPropertyPropertyIsGeniusMix;
    /**
     * \brief Number of occurrences of iAP2MediaPlayListPropertyPropertyIsGeniusMix parameter
     */
    U16 iAP2MediaPlayListPropertyPropertyIsGeniusMix_count;

    
    U8* iAP2MediaPlaylistContentTransfer;
    /**
     * \brief Number of occurrences of iAP2MediaPlaylistContentTransfer parameter
     */
    U16 iAP2MediaPlaylistContentTransfer_count;

} iAP2MediaPlaylistProperties;

/**
 * \brief PlaybackAttributes group
 */
typedef struct
{
    /**
    * \brief Now Playing Apple Music Radio Ad
    */
    U8* iAP2PBAppleMusicRadioAd;
    /**
     * \brief Number of occurrences of iAP2PBAppleMusicRadioAd parameter
     */
    U16 iAP2PBAppleMusicRadioAd_count;

    /**
    * \brief Name of the now playing Apple Music Radio station
    */
    U8** iAP2PBAppleMusicRadioStationName;
    /**
     * \brief Number of occurrences of iAP2PBAppleMusicRadioStationName parameter
     */
    U16 iAP2PBAppleMusicRadioStationName_count;

    /* The Parameter PBiTunesRadioAd is Deprecated, Don't use it. Kindly refer the Apple specification. */
    /**
    * \brief Now Playing iTunes Radio
    */
    U8* iAP2PBiTunesRadioAd;
    /**
     * \brief Number of occurrences of iAP2PBiTunesRadioAd parameter
     */
    U16 iAP2PBiTunesRadioAd_count;

    /* The Parameter PBiTunesRadioStationMediaPlaylistPersistentID is Deprecated, Don't use it. Kindly refer the Apple specification. */
    /**
    * \brief MediaPlaylist persistent identifer of NowPlaying iTunes Radio station
    */
    U64* iAP2PBiTunesRadioStationMediaPlaylistPersistentID;
    /**
     * \brief Number of occurrences of iAP2PBiTunesRadioStationMediaPlaylistPersistentID parameter
     */
    U16 iAP2PBiTunesRadioStationMediaPlaylistPersistentID_count;

    /* The Parameter PBiTunesRadioStationName is Deprecated, Don't use it. Kindly refer the Apple specification. */
    /**
    * \brief Name of the now playing iTunes Radio station
    */
    U8** iAP2PBiTunesRadioStationName;
    /**
     * \brief Number of occurrences of iAP2PBiTunesRadioStationName parameter
     */
    U16 iAP2PBiTunesRadioStationName_count;

    /**
    * \brief It can be used along with iAP2MediaItemPersistentIdentifier to fully
    *enumarate the source of the now playing media item
    */
    U8** iAP2PBMediaLibraryUniqueIdentifier;
    /**
     * \brief Number of occurrences of iAP2PBMediaLibraryUniqueIdentifier parameter
     */
    U16 iAP2PBMediaLibraryUniqueIdentifier_count;

    /**
    * \brief Playback App Bundle ID of now playing media
    */
    U8** iAP2PlaybackAppBundleID;
    /**
     * \brief Number of occurrences of iAP2PlaybackAppBundleID parameter
     */
    U16 iAP2PlaybackAppBundleID_count;

    /**
    * \brief Name of the now playing app
    */
    U8** iAP2PlaybackAppName;
    /**
     * \brief Number of occurrences of iAP2PlaybackAppName parameter
     */
    U16 iAP2PlaybackAppName_count;

    /**
    * \brief Elapsed time of now playing media in
    MilliSeconds
    */
    U32* iAP2PlaybackElapsedTimeInMilliseconds;
    /**
     * \brief Number of occurrences of iAP2PlaybackElapsedTimeInMilliseconds parameter
     */
    U16 iAP2PlaybackElapsedTimeInMilliseconds_count;

    /**
    * \brief Chapter index of Now Playing Queue
    */
    U32* iAP2PlaybackQueueChapterIndex;
    /**
     * \brief Number of occurrences of iAP2PlaybackQueueChapterIndex parameter
     */
    U16 iAP2PlaybackQueueChapterIndex_count;

    /**
    * \brief Playback queue count
    */
    U32* iAP2PlaybackQueueCount;
    /**
     * \brief Number of occurrences of iAP2PlaybackQueueCount parameter
     */
    U16 iAP2PlaybackQueueCount_count;

    /**
    * \brief Queue index of playback engine
    */
    U32* iAP2PlaybackQueueIndex;
    /**
     * \brief Number of occurrences of iAP2PlaybackQueueIndex parameter
     */
    U16 iAP2PlaybackQueueIndex_count;

    /**
    * \brief Availability of Playback Queue List of now playing media
    */
    U8* iAP2PlaybackQueueListAvail;
    /**
     * \brief Number of occurrences of iAP2PlaybackQueueListAvail parameter
     */
    U16 iAP2PlaybackQueueListAvail_count;

    /**
    * \brief Playback Queue List TransferID of now playing media
    */
    U8* iAP2PlaybackQueueListTransferID;
    /**
     * \brief Number of occurrences of iAP2PlaybackQueueListTransferID parameter
     */
    U16 iAP2PlaybackQueueListTransferID_count;

    /**
    * \brief Repeat mode of media playback engine.
    *
    * It refers to enum iAP2PlaybackRepeat
    */
    iAP2PlaybackRepeat* iAP2PlaybackRepeatMode;
    /**
     * \brief Number of occurrences of iAP2PlaybackRepeatMode parameter
     */
    U16 iAP2PlaybackRepeatMode_count;

    /**
    * \brief Shuffle mode of media playback engine
    *
    * It refers to enum iAP2PlaybackShuffle
    */
    iAP2PlaybackShuffle* iAP2PlaybackShuffleMode;
    /**
     * \brief Number of occurrences of iAP2PlaybackShuffleMode parameter
     */
    U16 iAP2PlaybackShuffleMode_count;

    /**
    * \brief Playback Speed of now playing media
    */
    U16* iAP2PlaybackSpeed;
    /**
     * \brief Number of occurrences of iAP2PlaybackSpeed parameter
     */
    U16 iAP2PlaybackSpeed_count;

    /**
    * \brief Playback status of now playing media
    */
    iAP2PlaybackStatus* iAP2PlaybackStatus;
    /**
     * \brief Number of occurrences of iAP2PlaybackStatus parameter
     */
    U16 iAP2PlaybackStatus_count;

    /**
    * \brief Availability of SetElapsedTime of now playing media
    */
    U8* iAP2SetElapsedTimeAvailable;
    /**
     * \brief Number of occurrences of iAP2SetElapsedTimeAvailable parameter
     */
    U16 iAP2SetElapsedTimeAvailable_count;

    
    U8* iAP2PlaybackQueueListContentTransfer;
    /**
     * \brief Number of occurrences of iAP2PlaybackQueueListContentTransfer parameter
     */
    U16 iAP2PlaybackQueueListContentTransfer_count;

    
    U64* iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID;
    /**
     * \brief Number of occurrences of iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID parameter
     */
    U16 iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID_count;

} iAP2PlaybackAttributes;

/**
 * \brief PlaybackQueueListContentTransferInfoRequest group
 */
typedef struct
{
    
    U8* iAP2MediaItemPID;
    /**
     * \brief Number of occurrences of iAP2MediaItemPID parameter
     */
    U16 iAP2MediaItemPID_count;

    
    U8* iAP2MediaItemTitle;
    /**
     * \brief Number of occurrences of iAP2MediaItemTitle parameter
     */
    U16 iAP2MediaItemTitle_count;

    
    U8* iAP2MediaItemAlbumTitle;
    /**
     * \brief Number of occurrences of iAP2MediaItemAlbumTitle parameter
     */
    U16 iAP2MediaItemAlbumTitle_count;

    
    U8* iAP2MediaItemArtist;
    /**
     * \brief Number of occurrences of iAP2MediaItemArtist parameter
     */
    U16 iAP2MediaItemArtist_count;

    
    U8* iAP2MediaItemAlbumArtist;
    /**
     * \brief Number of occurrences of iAP2MediaItemAlbumArtist parameter
     */
    U16 iAP2MediaItemAlbumArtist_count;

    
    U8* iAP2MediaItemGenre;
    /**
     * \brief Number of occurrences of iAP2MediaItemGenre parameter
     */
    U16 iAP2MediaItemGenre_count;

    
    U8* iAP2MediaItemComposer;
    /**
     * \brief Number of occurrences of iAP2MediaItemComposer parameter
     */
    U16 iAP2MediaItemComposer_count;

} iAP2PlaybackQueueListContentTransferInfoRequest;

/**
 * \brief RecentsList group
 */
typedef struct
{
    /**
    * \brief ID of Address Book
    */
    U8** iAP2AddressBookID;
    /**
     * \brief Number of occurrences of iAP2AddressBookID parameter
     */
    U16 iAP2AddressBookID_count;

    /**
    * \brief Display Name
    */
    U8** iAP2DisplayName;
    /**
     * \brief Number of occurrences of iAP2DisplayName parameter
     */
    U16 iAP2DisplayName_count;

    /**
    * \brief Duration in seconds
    * Only if occurrences = 1
    */
    U32* iAP2Duration;
    /**
     * \brief Number of occurrences of iAP2Duration parameter
     */
    U16 iAP2Duration_count;

    /**
    * \brief Request index of list entry 
    */
    U16* iAP2Index;
    /**
     * \brief Number of occurrences of iAP2Index parameter
     */
    U16 iAP2Index_count;

    /**
    * \brief Label if in contacts, location if not
    */
    U8** iAP2Label;
    /**
     * \brief Number of occurrences of iAP2Label parameter
     */
    U16 iAP2Label_count;

    
    U8* iAP2Occurrences;
    /**
     * \brief Number of occurrences of iAP2Occurrences parameter
     */
    U16 iAP2Occurrences_count;

    /**
    * \brief Remote phone number or email
    */
    U8** iAP2RemoteID;
    /**
     * \brief Number of occurrences of iAP2RemoteID parameter
     */
    U16 iAP2RemoteID_count;

    /**
    * \brief List Update Service
    */
    iAP2ListUpdateService* iAP2Service;
    /**
     * \brief Number of occurrences of iAP2Service parameter
     */
    U16 iAP2Service_count;

    /**
    * \brief List Update Recents List Type
    */
    iAP2ListUpdateRecentsListType* iAP2Type;
    /**
     * \brief Number of occurrences of iAP2Type parameter
     */
    U16 iAP2Type_count;

    /**
    * \brief UNIX Timestamp
    */
    U64* iAP2UnixTimestamp;
    /**
     * \brief Number of occurrences of iAP2UnixTimestamp parameter
     */
    U16 iAP2UnixTimestamp_count;

} iAP2RecentsList;

/**
 * \brief RecentsListProperties group
 */
typedef struct
{
    /**
    * \brief ID of Address Book
    */
    U8* iAP2AddressBookID;
    /**
     * \brief Number of occurrences of iAP2AddressBookID parameter
     */
    U16 iAP2AddressBookID_count;

    /**
    * \brief Display Name
    */
    U8* iAP2DisplayName;
    /**
     * \brief Number of occurrences of iAP2DisplayName parameter
     */
    U16 iAP2DisplayName_count;

    /**
    * \brief Duration in seconds
    *
    * Only if Occurrences = 1
    */
    U8* iAP2Duration;
    /**
     * \brief Number of occurrences of iAP2Duration parameter
     */
    U16 iAP2Duration_count;

    /**
    * \brief Request index of list entry
    */
    U8* iAP2Index;
    /**
     * \brief Number of occurrences of iAP2Index parameter
     */
    U16 iAP2Index_count;

    /**
    * \brief Label if in contacts, location if not
    */
    U8* iAP2Label;
    /**
     * \brief Number of occurrences of iAP2Label parameter
     */
    U16 iAP2Label_count;

    
    U8* iAP2Occurrences;
    /**
     * \brief Number of occurrences of iAP2Occurrences parameter
     */
    U16 iAP2Occurrences_count;

    /**
    * \brief Remote phone number or email
    */
    U8* iAP2RemoteID;
    /**
     * \brief Number of occurrences of iAP2RemoteID parameter
     */
    U16 iAP2RemoteID_count;

    /**
    * \brief List Update Service
    */
    U8* iAP2Service;
    /**
     * \brief Number of occurrences of iAP2Service parameter
     */
    U16 iAP2Service_count;

    /**
    * \brief List Update Recents List Type
    */
    U8* iAP2Type;
    /**
     * \brief Number of occurrences of iAP2Type parameter
     */
    U16 iAP2Type_count;

    /**
    * \brief UNIX Timestamp
    */
    U8* iAP2UnixTimestamp;
    /**
     * \brief Number of occurrences of iAP2UnixTimestamp parameter
     */
    U16 iAP2UnixTimestamp_count;

} iAP2RecentsListProperties;

/**
 * \brief RouteGuidanceDisplayComponent group
 */
typedef struct
{
    /**
    * \brief Route Guidance Display Component Identifier
    */
    U16* iAP2Identifier;
    /**
     * \brief Number of occurrences of iAP2Identifier parameter
     */
    U16 iAP2Identifier_count;

    /**
    * \brief Route Guidance Display Component Name
    */
    U8** iAP2Name;
    /**
     * \brief Number of occurrences of iAP2Name parameter
     */
    U16 iAP2Name_count;

    /**
    * \brief Maximum number of characters that can be displayed by the accessory for Current Road Name
    */
    U16* iAP2MaxCurrentRoadNameLength;
    /**
     * \brief Number of occurrences of iAP2MaxCurrentRoadNameLength parameter
     */
    U16 iAP2MaxCurrentRoadNameLength_count;

    /**
    * \brief Maximum number of characters that can be displayed by the accessory for Destination Road Name
    */
    U16* iAP2MaxDestinationRoadNameLength;
    /**
     * \brief Number of occurrences of iAP2MaxDestinationRoadNameLength parameter
     */
    U16 iAP2MaxDestinationRoadNameLength_count;

    /**
    * \brief Maximum number of characters that can be displayed by the accessory for After Maneuver Road Name
    */
    U16* iAP2MaxAfterManeuverRoadNameLength;
    /**
     * \brief Number of occurrences of iAP2MaxAfterManeuverRoadNameLength parameter
     */
    U16 iAP2MaxAfterManeuverRoadNameLength_count;

    /**
    * \brief Maximum number of characters that can be displayed by the accessory for Maneuver Description
    */
    U16* iAP2MaxManeuverDescriptionLength;
    /**
     * \brief Number of occurrences of iAP2MaxManeuverDescriptionLength parameter
     */
    U16 iAP2MaxManeuverDescriptionLength_count;

    /**
    * \brief Maximum number of maneuvers the accessory can handle
    */
    U16* iAP2MaxGuidanceManeuverStorageCapacity;
    /**
     * \brief Number of occurrences of iAP2MaxGuidanceManeuverStorageCapacity parameter
     */
    U16 iAP2MaxGuidanceManeuverStorageCapacity_count;

} iAP2RouteGuidanceDisplayComponent;

/**
 * \brief SerialTransportComponent group
 */
typedef struct
{
    /**
    * \brief Unique identifier for Serial transport
    */
    U16* iAP2TransportComponentIdentifier;
    /**
     * \brief Number of occurrences of iAP2TransportComponentIdentifier parameter
     */
    U16 iAP2TransportComponentIdentifier_count;

    /**
    * \brief Serial Transport component name
    *
    * It takes null-terminated UTF-8 string
    */
    U8** iAP2TransportComponentName;
    /**
     * \brief Number of occurrences of iAP2TransportComponentName parameter
     */
    U16 iAP2TransportComponentName_count;

    /**
    * \brief Present, If Serial transport supports iAP2 connection
    */
    U8* iAP2TransportSupportsiAP2Connection;
    /**
     * \brief Number of occurrences of iAP2TransportSupportsiAP2Connection parameter
     */
    U16 iAP2TransportSupportsiAP2Connection_count;

} iAP2SerialTransportComponent;

/**
 * \brief StartNowPlayingPlaybackAttributes group
 */
typedef struct
{
    /**
    * \brief Present, if application wish to receive MediaPlaylist persistent identifier 
    of NowPlaying Apple Music Radio station
    */
    U8* iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID;
    /**
     * \brief Number of occurrences of iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID parameter
     */
    U16 iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID_count;

    /**
    * \brief Present, if application wish to receive Now Playing Apple Music Radio Ad
    */
    U8* iAP2PBAppleMusicRadioAd;
    /**
     * \brief Number of occurrences of iAP2PBAppleMusicRadioAd parameter
     */
    U16 iAP2PBAppleMusicRadioAd_count;

    /**
    * \brief Present, if application wish to receive name of the now playing Apple Music Radio station
    */
    U8* iAP2PBAppleMusicRadioStationName;
    /**
     * \brief Number of occurrences of iAP2PBAppleMusicRadioStationName parameter
     */
    U16 iAP2PBAppleMusicRadioStationName_count;

    /* The Parameter PBiTunesRadioAd is Deprecated, Don't use it. Kindly refer the Apple specification. */
    /**
    * \brief Present, if application wish to receive Now Playing iTunes Radio
    */
    U8* iAP2PBiTunesRadioAd;
    /**
     * \brief Number of occurrences of iAP2PBiTunesRadioAd parameter
     */
    U16 iAP2PBiTunesRadioAd_count;

    /* The Parameter PBiTunesStationMediaPlaylistPersistentID is Deprecated, Don't use it. Kindly refer the Apple specification. */
    /**
    * \brief Present, if application wish to receive MediaPlaylist persistent identifier 
    of NowPlaying iTunes Radio station
    */
    U8* iAP2PBiTunesStationMediaPlaylistPersistentID;
    /**
     * \brief Number of occurrences of iAP2PBiTunesStationMediaPlaylistPersistentID parameter
     */
    U16 iAP2PBiTunesStationMediaPlaylistPersistentID_count;

    /* The Parameter PBiTunesStationName is Deprecated, Don't use it. Kindly refer the Apple specification. */
    /**
    * \brief Present, if application wish to receive name of the now playing iTunes Radio station
    */
    U8* iAP2PBiTunesStationName;
    /**
     * \brief Number of occurrences of iAP2PBiTunesStationName parameter
     */
    U16 iAP2PBiTunesStationName_count;

    /**
    * \brief Present if application wish to receive 
    * Playback App BundleID of now playing media
    */
    U8* iAP2PlaybackAppBundleID;
    /**
     * \brief Number of occurrences of iAP2PlaybackAppBundleID parameter
     */
    U16 iAP2PlaybackAppBundleID_count;

    /**
    * \brief Present, if application wish to receive name of the now playing app
    */
    U8* iAP2PlaybackAppName;
    /**
     * \brief Number of occurrences of iAP2PlaybackAppName parameter
     */
    U16 iAP2PlaybackAppName_count;

    /**
    * \brief Present if application wish to receive Elapsed time of now playing media in
    * MilliSeconds
    */
    U8* iAP2PlaybackElapsedTimeInMilliseconds;
    /**
     * \brief Number of occurrences of iAP2PlaybackElapsedTimeInMilliseconds parameter
     */
    U16 iAP2PlaybackElapsedTimeInMilliseconds_count;

    /**
    * \brief Present if application wish to receive Media Library Identifier of 
    * the playback
    */
    U8* iAP2PlaybackMediaLibraryUniqueIdentifier;
    /**
     * \brief Number of occurrences of iAP2PlaybackMediaLibraryUniqueIdentifier parameter
     */
    U16 iAP2PlaybackMediaLibraryUniqueIdentifier_count;

    /**
    * \brief Present if application wish to receive Chapter index of Now Playing Queue
    */
    U8* iAP2PlaybackQueueChapterIndex;
    /**
     * \brief Number of occurrences of iAP2PlaybackQueueChapterIndex parameter
     */
    U16 iAP2PlaybackQueueChapterIndex_count;

    /**
    * \brief Present if application wish to receive Playback queue count
    */
    U8* iAP2PlaybackQueueCount;
    /**
     * \brief Number of occurrences of iAP2PlaybackQueueCount parameter
     */
    U16 iAP2PlaybackQueueCount_count;

    /**
    * \brief Present if application wish to receive Queue index of playback engine
    */
    U8* iAP2PlaybackQueueIndex;
    /**
     * \brief Number of occurrences of iAP2PlaybackQueueIndex parameter
     */
    U16 iAP2PlaybackQueueIndex_count;

    /**
    * \brief Present if application wish to know whether
    * iOS device has Playback Queue list
    */
    U8* iAP2PlaybackQueueListAvail;
    /**
     * \brief Number of occurrences of iAP2PlaybackQueueListAvail parameter
     */
    U16 iAP2PlaybackQueueListAvail_count;

    /**
    * \brief Present if application wish to receive 
    * Playback Queue List TransferID of now playing media
    */
    U8* iAP2PlaybackQueueListTransferID;
    /**
     * \brief Number of occurrences of iAP2PlaybackQueueListTransferID parameter
     */
    U16 iAP2PlaybackQueueListTransferID_count;

    /**
    * \brief Present, if application wish to receive repeat mode of media playback engine.
    */
    U8* iAP2PlaybackRepeatMode;
    /**
     * \brief Number of occurrences of iAP2PlaybackRepeatMode parameter
     */
    U16 iAP2PlaybackRepeatMode_count;

    /**
    * \brief Present, if application wish to receive Shuffle mode of media playback engine
    */
    U8* iAP2PlaybackShuffleMode;
    /**
     * \brief Number of occurrences of iAP2PlaybackShuffleMode parameter
     */
    U16 iAP2PlaybackShuffleMode_count;

    /**
    * \brief Present if application wish to receive Playback Speed of now playing media
    */
    U8* iAP2PlaybackSpeed;
    /**
     * \brief Number of occurrences of iAP2PlaybackSpeed parameter
     */
    U16 iAP2PlaybackSpeed_count;

    /**
    * \brief Present if application wish to receive Playback status of now playing media
    */
    U8* iAP2PlaybackStatus;
    /**
     * \brief Number of occurrences of iAP2PlaybackStatus parameter
     */
    U16 iAP2PlaybackStatus_count;

    /**
    * \brief Present if application wish to know whether iOS 
    * Device supports SetElapsedTime feature.
    */
    U8* iAP2SetElapsedTimeAvailable;
    /**
     * \brief Number of occurrences of iAP2SetElapsedTimeAvailable parameter
     */
    U16 iAP2SetElapsedTimeAvailable_count;

    /**
    * \brief The maximum number of entries the accessory can handle.
    * Specifying 0 will send the full list.
    */
    U32* iAP2PlaybackQueueListContentTransferSize;
    /**
     * \brief Number of occurrences of iAP2PlaybackQueueListContentTransferSize parameter
     */
    U16 iAP2PlaybackQueueListContentTransferSize_count;

} iAP2StartNowPlayingPlaybackAttributes;

/**
 * \brief USBDeviceTransportComponent group
 */
typedef struct
{
    /**
    * \brief Component identifier of USB device transport.
    *
    * All iAP2TransportComponentIdentifiers must be unique.
    */
    U16* iAP2TransportComponentIdentifier;
    /**
     * \brief Number of occurrences of iAP2TransportComponentIdentifier parameter
     */
    U16 iAP2TransportComponentIdentifier_count;

    /**
    * \brief Component name of USB device transport.
    *
    * It takes null-terminated UTF-8 string.
    */
    U8** iAP2TransportComponentName;
    /**
     * \brief Number of occurrences of iAP2TransportComponentName parameter
     */
    U16 iAP2TransportComponentName_count;

    /** 
    * \brief Present, if USB device transport supports iAP2 connection
    */
    U8* iAP2TransportSupportsiAP2Connection;
    /**
     * \brief Number of occurrences of iAP2TransportSupportsiAP2Connection parameter
     */
    U16 iAP2TransportSupportsiAP2Connection_count;

    /**
    * \brief Array of multiple sample rate values possible
    *
    * It refers to enum iAP2USBDeviceModeAudioSampleRate
    */
    iAP2USBDeviceModeAudioSampleRate* iAP2USBDeviceSupportedAudioSampleRate;
    /**
     * \brief Number of occurrences of iAP2USBDeviceSupportedAudioSampleRate parameter
     */
    U16 iAP2USBDeviceSupportedAudioSampleRate_count;

} iAP2USBDeviceTransportComponent;

/**
 * \brief USBHostHIDComponent group
 */
typedef struct
{
    /**
    * \brief It specifies USB Host HID component function type.
    *
    * It refers to enum iAP2HIDComponentFunction
    */
    iAP2HIDComponentFunction* iAP2HIDComponentFunction;
    /**
     * \brief Number of occurrences of iAP2HIDComponentFunction parameter
     */
    U16 iAP2HIDComponentFunction_count;

    /**
    * \brief Identifier of USB Host HID component.
    *
    * Must be unique HIDComponentIdentifier specified by the Accessory
    */
    U16* iAP2HIDComponentIdentifier;
    /**
     * \brief Number of occurrences of iAP2HIDComponentIdentifier parameter
     */
    U16 iAP2HIDComponentIdentifier_count;

    /**
    * \brief Name of USB Host HID component.
    *
    * It takes null-terminated UTF-8 string
    */
    U8** iAP2HIDComponentName;
    /**
     * \brief Number of occurrences of iAP2HIDComponentName parameter
     */
    U16 iAP2HIDComponentName_count;

    /**
    * \brief Refers to iAP2USBHostTransportComponentIdentifier of an iAP2USBHostTransportComponent
    */
    U16* iAP2USBHostTransportComponentIdentifier;
    /**
     * \brief Number of occurrences of iAP2USBHostTransportComponentIdentifier parameter
     */
    U16 iAP2USBHostTransportComponentIdentifier_count;

    /**
    * \brief Must match the accessory's corresponding USB device interface descriptor. 
    *
    * If more than one USBHostHIDComponent is present, the accessory must present multiple USB HID interfaces with unique interface numbers.
    */
    U16* iAP2USBHostTransportInterfaceNumber;
    /**
     * \brief Number of occurrences of iAP2USBHostTransportInterfaceNumber parameter
     */
    U16 iAP2USBHostTransportInterfaceNumber_count;

} iAP2USBHostHIDComponent;

/**
 * \brief USBHostTransportComponent group
 */
typedef struct
{
    /**
    * \brief USB Host Transport component Identifier.
    *
    * All iAP2TransportComponentIdentifiers must be unique.
    */
    U16* iAP2TransportComponentIdentifier;
    /**
     * \brief Number of occurrences of iAP2TransportComponentIdentifier parameter
     */
    U16 iAP2TransportComponentIdentifier_count;

    /**
    * \brief Name of USB host transport component
    *
    * It is of type Null-terminated UTF-8 string
    */
    U8** iAP2TransportComponentName;
    /**
     * \brief Number of occurrences of iAP2TransportComponentName parameter
     */
    U16 iAP2TransportComponentName_count;

    /**
    * \brief present, if USB host transport component supports
    CarPlay
    */
    U8* iAP2TransportSupportsCarPlay;
    /**
     * \brief Number of occurrences of iAP2TransportSupportsCarPlay parameter
     */
    U16 iAP2TransportSupportsCarPlay_count;

    /**
    * \brief present, if USB host transport component supports
    iAP2 connection
    */
    U8* iAP2TransportSupportsiAP2Connection;
    /**
     * \brief Number of occurrences of iAP2TransportSupportsiAP2Connection parameter
     */
    U16 iAP2TransportSupportsiAP2Connection_count;

    /**
    * \brief USB Host transport Digital iPod Out interface number
    */
    U8* iAP2USBHostTransportCarPlaytInterfaceNumber;
    /**
     * \brief Number of occurrences of iAP2USBHostTransportCarPlaytInterfaceNumber parameter
     */
    U16 iAP2USBHostTransportCarPlaytInterfaceNumber_count;

} iAP2USBHostTransportComponent;

/**
 * \brief VehicleInformationComponent group
 */
typedef struct
{
    
    U8** iAP2DisplayName;
    /**
     * \brief Number of occurrences of iAP2DisplayName parameter
     */
    U16 iAP2DisplayName_count;

    /**
    * \brief Engine type of the vehicle.
    *
    *It refers to enum iAP2EngineTypes
    */
    iAP2EngineTypes* iAP2EngineType;
    /**
     * \brief Number of occurrences of iAP2EngineType parameter
     */
    U16 iAP2EngineType_count;

    /**
    * \brief Identifier of Vehicle Information Component
    */
    U16* iAP2Identifier;
    /**
     * \brief Number of occurrences of iAP2Identifier parameter
     */
    U16 iAP2Identifier_count;

    /**
    * \brief Name of Vehicle Information Component
    */
    U8** iAP2Name;
    /**
     * \brief Number of occurrences of iAP2Name parameter
     */
    U16 iAP2Name_count;

} iAP2VehicleInformationComponent;

/**
 * \brief VehicleStatusComponent group
 */
typedef struct
{
    /**
    * \brief Identifier of VehicleStatusComponent
    *
    * All VehicleStatusComponentIdentifiers must be unique
    */
    U16* iAP2Identifier;
    /**
     * \brief Number of occurrences of iAP2Identifier parameter
     */
    U16 iAP2Identifier_count;

    /* The Parameter InsideTemperature is Deprecated, Don't use it. Kindly refer the Apple specification. */
    /**
    * \brief Present if application wish to receive inside temperature of the vehicle
    */
    U8* iAP2InsideTemperature;
    /**
     * \brief Number of occurrences of iAP2InsideTemperature parameter
     */
    U16 iAP2InsideTemperature_count;

    /**
    * \brief Name of VehicleStatusComponent
    */
    U8** iAP2Name;
    /**
     * \brief Number of occurrences of iAP2Name parameter
     */
    U16 iAP2Name_count;

    /* The Parameter NightMode is Deprecated, Don't use it. Kindly refer the Apple specification. */
    /**
    * \brief Present if application wish to receive night mode status of the vehicle
    */
    U8* iAP2NightMode;
    /**
     * \brief Number of occurrences of iAP2NightMode parameter
     */
    U16 iAP2NightMode_count;

    /**
    * \brief Present if application wish to receive outside temperature of the vehicle
    */
    U8* iAP2OutsideTemperature;
    /**
     * \brief Number of occurrences of iAP2OutsideTemperature parameter
     */
    U16 iAP2OutsideTemperature_count;

    /**
    * \brief Present if application wish to receive remaining vehicle range
    */
    U8* iAP2Range;
    /**
     * \brief Number of occurrences of iAP2Range parameter
     */
    U16 iAP2Range_count;

    /**
    * \brief Present if application wish to receive whether low range warning is set or not
    */
    U8* iAP2RangeWarning;
    /**
     * \brief Number of occurrences of iAP2RangeWarning parameter
     */
    U16 iAP2RangeWarning_count;

} iAP2VehicleStatusComponent;

/**
 * \brief WirelessCarPlayTransportComponent group
 */
typedef struct
{
    /**
    * \brief Transport Component Identifier
    *
    * All Transport Component identifiers must be unique
    */
    U16* iAP2TransportComponentIdentifier;
    /**
     * \brief Number of occurrences of iAP2TransportComponentIdentifier parameter
     */
    U16 iAP2TransportComponentIdentifier_count;

    /**
    * \brief Transport Component Name
    */
    U8** iAP2TransportComponentName;
    /**
     * \brief Number of occurrences of iAP2TransportComponentName parameter
     */
    U16 iAP2TransportComponentName_count;

    /**
    * \brief Whether Transport Supports CarPlay
    */
    U8* iAP2TransportSupportsCarPlay;
    /**
     * \brief Number of occurrences of iAP2TransportSupportsCarPlay parameter
     */
    U16 iAP2TransportSupportsCarPlay_count;

    /**
    * \brief Whether Transport Supports iAP2 Connection
    */
    U8* iAP2TransportSupportsiAP2Connection;
    /**
     * \brief Number of occurrences of iAP2TransportSupportsiAP2Connection parameter
     */
    U16 iAP2TransportSupportsiAP2Connection_count;

} iAP2WirelessCarPlayTransportComponent;

#ifdef __cplusplus
}
#endif

#endif
